package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Location;

public class VSSCWebDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {

	@Override
	public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Location site, final boolean isIndependentOnly) {
		
		if (isDartRequest(req) == false) {
			return false;
		}
		
		DartRequest dartRequest = (DartRequest)req;
		
		if (temp.getName().startsWith("IRB Approval of Waiver of HIPAA") && dartRequest.isHipaaWaiver() == true) {
			return true;
		}
		
		if (temp.getName().startsWith("Research and Development (RD) Committee Approval")) {
			return true;
		}
		
		if (temp.getName().startsWith("Research Study Institutional Review Board (IRB) Approval")) {
			return true;
		}
		
		if (temp.getName().startsWith("Research Protocol")) {
			return true;
		}
		
		Location primarySite = req.getPrimaryLocation();
		if (primarySite != null) {

			if (temp.getName().startsWith("Research Request Memo") && site.getId() == primarySite.getId()) {
				return true;
			}
			
			if (temp.getName().startsWith("Sample Informed Consent") && site.getId() == primarySite.getId() && dartRequest.isHipaaConsent() == true) {
				return true;
			}

            // As per DUA document item 1.10, include DUA if transferredexternal = true
            // Data Use Agreement is required for the primary site
            if (temp.getName().startsWith("Data Use Agreement") && site.getId() == primarySite.getId() && dartRequest.isTransferredExternal() == true) {
                return true;
            }
        }
		
		return false;
	}
}
